/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.sumo.util;

import de.uniluebeck.itm.tcpip.Storage;
import it.polito.appeal.traci.TraCIException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class StringList
implements List<String> {
    private final List<String> list;

    public StringList() {
        this.list = new ArrayList<String>();
    }

    public StringList(List<String> list) {
        this.list = list;
    }

    public StringList(Storage storage, boolean verifyType) throws TraCIException {
        if (verifyType && storage.readByte() != 14) {
            throw new TraCIException("string list expected");
        }
        int len = storage.readInt();
        this.list = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            this.list.add(storage.readStringASCII());
        }
    }

    public void writeTo(Storage out, boolean writeTypeID) {
        if (writeTypeID) {
            out.writeByte(14);
        }
        out.writeInt(this.list.size());
        for (String str : this.list) {
            out.writeStringASCII(str);
        }
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public void add(int index, String element) {
        this.list.add(index, element);
    }

    @Override
    public boolean add(String e) {
        return this.list.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public String get(int index) {
        return this.list.get(index);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<String> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public String remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public String set(int index, String element) {
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

