/*
 * Decompiled with CFR 0.152.
 */
package de.uniluebeck.itm.tcpip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class Storage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Byte> storageList;
    private int position;
    private ListIterator<Byte> listIt;

    public Storage() {
        this.storageList = new ArrayList<Byte>();
        this.init();
    }

    public Storage(byte[] packet) {
        this(packet, 0, packet.length);
    }

    public Storage(byte[] packet, int offset, int length) {
        if (packet == null) {
            throw new NullPointerException("packet can't be null");
        }
        if (length > packet.length) {
            throw new IndexOutOfBoundsException("length exceeds packet length");
        }
        if (offset + length > packet.length) {
            throw new IndexOutOfBoundsException("content is outside the array");
        }
        this.storageList = new ArrayList<Byte>();
        for (int i = offset; i < length; ++i) {
            this.writeByte(packet[i]);
        }
        this.init();
    }

    public Storage(short[] packet) {
        this(packet, 0, packet.length);
    }

    public Storage(short[] packet, int offset, int length) {
        if (packet == null) {
            throw new NullPointerException("packet can't be null");
        }
        if (length > packet.length) {
            throw new IndexOutOfBoundsException("length exceeds packet length");
        }
        if (offset + length > packet.length) {
            throw new IndexOutOfBoundsException("content is outside the array");
        }
        this.storageList = new ArrayList<Byte>();
        for (int i = offset; i < length; ++i) {
            this.writeByte(packet[i]);
        }
        this.init();
    }

    public boolean validPos() {
        return this.position < this.storageList.size() && this.position >= 0 && this.storageList.size() != 0;
    }

    public int position() {
        return this.position;
    }

    public void writeByte(short value) throws IllegalArgumentException {
        this.writeByte((int)value);
    }

    public void writeByte(int value) throws IllegalArgumentException {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("Error writing byte: byte value may only range from -128 to 127.");
        }
        this.storageList.add((byte)value);
    }

    public short readByte() throws IllegalStateException {
        if (!this.validPos()) {
            throw new IllegalStateException("Error reading byte, invalid list position specified for reading: " + this.position);
        }
        ++this.position;
        return this.listIt.next().byteValue();
    }

    public void writeUnsignedByte(short value) throws IllegalArgumentException {
        this.writeUnsignedByte((int)value);
    }

    public void writeUnsignedByte(int value) throws IllegalArgumentException {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Error writing unsigned byte: byte value may only range from 0 to 255.");
        }
        if (value > 127) {
            this.storageList.add((byte)(value - 256));
        } else {
            this.storageList.add((byte)value);
        }
    }

    public short readUnsignedByte() throws IllegalStateException {
        if (!this.validPos()) {
            throw new IllegalStateException("Error reading unsigned byte, invalid list position specified for reading: " + this.position);
        }
        ++this.position;
        return (short)((this.listIt.next() + 256) % 256);
    }

    public void writeShort(int value) throws IllegalArgumentException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(2);
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        byte[] bytes = new byte[2];
        if (value < Short.MIN_VALUE || value > 32768) {
            throw new IllegalArgumentException("Error writing short: short value may only range from -32768 to 32768.");
        }
        try {
            dataOut.writeShort(value);
            dataOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        bytes = byteOut.toByteArray();
        for (int i = 0; i < 2; ++i) {
            this.writeByte(bytes[i]);
        }
    }

    public int readShort() throws IllegalStateException {
        byte[] content = new byte[2];
        short result = 0;
        for (int i = 0; i < 2; ++i) {
            content[i] = (byte)this.readByte();
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(content);
        DataInputStream dataIn = new DataInputStream(byteIn);
        try {
            result = dataIn.readShort();
            dataIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void writeInt(int value) throws IllegalArgumentException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(4);
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        byte[] bytes = new byte[4];
        try {
            dataOut.writeInt(value);
            dataOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        bytes = byteOut.toByteArray();
        for (int i = 0; i < 4; ++i) {
            this.writeByte(bytes[i]);
        }
    }

    public int readInt() throws IllegalStateException {
        byte[] content = new byte[4];
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            content[i] = (byte)this.readByte();
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(content);
        DataInputStream dataIn = new DataInputStream(byteIn);
        try {
            result = dataIn.readInt();
            dataIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void writeFloat(float value) throws IllegalArgumentException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(4);
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        byte[] bytes = new byte[4];
        try {
            dataOut.writeFloat(value);
            dataOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        bytes = byteOut.toByteArray();
        for (int i = 0; i < 4; ++i) {
            this.writeByte(bytes[i]);
        }
    }

    public float readFloat() throws IllegalStateException {
        byte[] content = new byte[4];
        float result = 0.0f;
        for (int i = 0; i < 4; ++i) {
            content[i] = (byte)this.readByte();
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(content);
        DataInputStream dataIn = new DataInputStream(byteIn);
        try {
            result = dataIn.readFloat();
            dataIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void writeDouble(double value) throws IllegalArgumentException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(8);
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        byte[] bytes = new byte[8];
        try {
            dataOut.writeDouble(value);
            dataOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        bytes = byteOut.toByteArray();
        for (int i = 0; i < 8; ++i) {
            this.writeByte(bytes[i]);
        }
    }

    public double readDouble() throws IllegalStateException {
        byte[] content = new byte[8];
        double result = 0.0;
        for (int i = 0; i < 8; ++i) {
            content[i] = (byte)this.readByte();
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(content);
        DataInputStream dataIn = new DataInputStream(byteIn);
        try {
            result = dataIn.readDouble();
            dataIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void writeStringUTF8(String value) throws IllegalArgumentException {
        this.writeString(value, "UTF-8");
    }

    public void writeStringASCII(String value) throws IllegalArgumentException {
        this.writeString(value, "US-ASCII");
    }

    public void writeStringISOLATIN1(String value) throws IllegalArgumentException {
        this.writeString(value, "ISO-8859-1");
    }

    public void writeStringUTF16BE(String value) throws IllegalArgumentException {
        this.writeString(value, "UTF-16BE");
    }

    public void writeStringUTF16LE(String value) throws IllegalArgumentException {
        this.writeString(value, "UTF-16LE");
    }

    private void writeString(String value, String charset) throws IllegalArgumentException {
        byte[] bytes;
        try {
            bytes = value.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        this.writeInt(value.length());
        for (int i = 0; i < bytes.length; ++i) {
            this.writeByte(bytes[i]);
        }
    }

    public String readStringUTF8() throws IllegalArgumentException {
        return this.readString("UTF-8");
    }

    public String readStringASCII() throws IllegalArgumentException {
        return this.readString("US-ASCII");
    }

    public String readStringISOLATIN1() throws IllegalArgumentException {
        return this.readString("ISO-8859-1");
    }

    public String readStringUTF16BE() throws IllegalArgumentException {
        return this.readString("UTF-16BE");
    }

    public String readStringUTF16LE() throws IllegalArgumentException {
        return this.readString("UTF-16LE");
    }

    private String readString(String charset) throws IllegalStateException {
        String result = new String("");
        int length = this.readInt();
        byte[] content = new byte[length];
        for (int i = 0; i < length; ++i) {
            content[i] = (byte)this.readByte();
        }
        try {
            result = new String(content, charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void reset() {
        this.storageList.clear();
        this.init();
    }

    public int size() {
        return this.storageList.size();
    }

    public List<Byte> getStorageList() {
        return Collections.unmodifiableList(this.storageList);
    }

    private void init() {
        this.position = 0;
        this.listIt = this.storageList.listIterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.storageList.size(); ++i) {
            if (i == this.position) {
                sb.append("[");
            } else {
                sb.append(" ");
            }
            sb.append(String.format("%02X", this.storageList.get(i)));
        }
        return sb.toString();
    }

    public String debug() {
        return "storageSize=" + this.storageList.size() + " pos=" + this.position + " storage=" + this.storageList;
    }
}

