/*
 * Decompiled with CFR 0.152.
 */
package it.polito.appeal.traci.protocol;

import de.uniluebeck.itm.tcpip.Storage;
import java.io.IOException;

public class StatusResponse {
    private final int id;
    private final int result;
    private final String description;

    public StatusResponse(int id) {
        this(id, 0, "");
    }

    public StatusResponse(int id, int result, String description) {
        this.id = id;
        this.result = result;
        this.description = description;
    }

    public StatusResponse(Storage packet) throws IOException {
        short len = packet.readByte();
        if (len == 0) {
            packet.readInt();
        }
        this.id = packet.readUnsignedByte();
        this.result = packet.readUnsignedByte();
        this.description = packet.readStringASCII();
    }

    public int id() {
        return this.id;
    }

    public int result() {
        return this.result;
    }

    public String description() {
        return this.description;
    }

    public void writeTo(Storage out) throws IOException {
        out.writeByte(0);
        out.writeInt(11 + this.description.length());
        out.writeByte(this.id);
        out.writeByte(this.result);
        out.writeStringASCII(this.description);
    }
}

