/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.eclipse.sumo.libsumo;

public class Person {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Person(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Person obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(Person obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsumoJNI.delete_Person(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  public static double getSpeed(String personID) {
    return libsumoJNI.Person_getSpeed(personID);
  }

  public static TraCIPosition getPosition(String personID, boolean includeZ) {
    return new TraCIPosition(libsumoJNI.Person_getPosition__SWIG_0(personID, includeZ), true);
  }

  public static TraCIPosition getPosition(String personID) {
    return new TraCIPosition(libsumoJNI.Person_getPosition__SWIG_1(personID), true);
  }

  public static TraCIPosition getPosition3D(String personID) {
    return new TraCIPosition(libsumoJNI.Person_getPosition3D(personID), true);
  }

  public static String getRoadID(String personID) {
    return libsumoJNI.Person_getRoadID(personID);
  }

  public static String getLaneID(String personID) {
    return libsumoJNI.Person_getLaneID(personID);
  }

  public static String getTypeID(String personID) {
    return libsumoJNI.Person_getTypeID(personID);
  }

  public static double getWaitingTime(String personID) {
    return libsumoJNI.Person_getWaitingTime(personID);
  }

  public static String getNextEdge(String personID) {
    return libsumoJNI.Person_getNextEdge(personID);
  }

  public static String getVehicle(String personID) {
    return libsumoJNI.Person_getVehicle(personID);
  }

  public static int getRemainingStages(String personID) {
    return libsumoJNI.Person_getRemainingStages(personID);
  }

  public static TraCIStage getStage(String personID, int nextStageIndex) {
    return new TraCIStage(libsumoJNI.Person_getStage__SWIG_0(personID, nextStageIndex), true);
  }

  public static TraCIStage getStage(String personID) {
    return new TraCIStage(libsumoJNI.Person_getStage__SWIG_1(personID), true);
  }

  public static StringVector getEdges(String personID, int nextStageIndex) {
    return new StringVector(libsumoJNI.Person_getEdges__SWIG_0(personID, nextStageIndex), true);
  }

  public static StringVector getEdges(String personID) {
    return new StringVector(libsumoJNI.Person_getEdges__SWIG_1(personID), true);
  }

  public static double getAngle(String personID) {
    return libsumoJNI.Person_getAngle(personID);
  }

  public static double getSlope(String personID) {
    return libsumoJNI.Person_getSlope(personID);
  }

  public static double getLanePosition(String personID) {
    return libsumoJNI.Person_getLanePosition(personID);
  }

  public static double getWalkingDistance(String personID, String edgeID, double pos, int laneIndex) {
    return libsumoJNI.Person_getWalkingDistance__SWIG_0(personID, edgeID, pos, laneIndex);
  }

  public static double getWalkingDistance(String personID, String edgeID, double pos) {
    return libsumoJNI.Person_getWalkingDistance__SWIG_1(personID, edgeID, pos);
  }

  public static double getWalkingDistance2D(String personID, double x, double y) {
    return libsumoJNI.Person_getWalkingDistance2D(personID, x, y);
  }

  public static TraCIReservationVector getTaxiReservations(int onlyNew) {
    return new TraCIReservationVector(libsumoJNI.Person_getTaxiReservations__SWIG_0(onlyNew), true);
  }

  public static TraCIReservationVector getTaxiReservations() {
    return new TraCIReservationVector(libsumoJNI.Person_getTaxiReservations__SWIG_1(), true);
  }

  public static String splitTaxiReservation(String reservationID, StringVector personIDs) {
    return libsumoJNI.Person_splitTaxiReservation(reservationID, StringVector.getCPtr(personIDs), personIDs);
  }

  public static StringVector getIDList() {
    return new StringVector(libsumoJNI.Person_getIDList(), true);
  }

  public static int getIDCount() {
    return libsumoJNI.Person_getIDCount();
  }

  public static String getParameter(String objectID, String key) {
    return libsumoJNI.Person_getParameter(objectID, key);
  }

  public static StringStringPair getParameterWithKey(String objectID, String key) {
    return new StringStringPair(libsumoJNI.Person_getParameterWithKey(objectID, key), true);
  }

  public static void setParameter(String objectID, String key, String value) {
    libsumoJNI.Person_setParameter(objectID, key, value);
  }

  public static double getLength(String typeID) {
    return libsumoJNI.Person_getLength(typeID);
  }

  public static double getMaxSpeed(String typeID) {
    return libsumoJNI.Person_getMaxSpeed(typeID);
  }

  public static String getVehicleClass(String typeID) {
    return libsumoJNI.Person_getVehicleClass(typeID);
  }

  public static double getSpeedFactor(String typeID) {
    return libsumoJNI.Person_getSpeedFactor(typeID);
  }

  public static double getAccel(String typeID) {
    return libsumoJNI.Person_getAccel(typeID);
  }

  public static double getDecel(String typeID) {
    return libsumoJNI.Person_getDecel(typeID);
  }

  public static double getEmergencyDecel(String typeID) {
    return libsumoJNI.Person_getEmergencyDecel(typeID);
  }

  public static double getApparentDecel(String typeID) {
    return libsumoJNI.Person_getApparentDecel(typeID);
  }

  public static double getImperfection(String typeID) {
    return libsumoJNI.Person_getImperfection(typeID);
  }

  public static double getTau(String typeID) {
    return libsumoJNI.Person_getTau(typeID);
  }

  public static String getEmissionClass(String typeID) {
    return libsumoJNI.Person_getEmissionClass(typeID);
  }

  public static String getShapeClass(String typeID) {
    return libsumoJNI.Person_getShapeClass(typeID);
  }

  public static double getMinGap(String typeID) {
    return libsumoJNI.Person_getMinGap(typeID);
  }

  public static double getWidth(String typeID) {
    return libsumoJNI.Person_getWidth(typeID);
  }

  public static double getHeight(String typeID) {
    return libsumoJNI.Person_getHeight(typeID);
  }

  public static double getMass(String typeID) {
    return libsumoJNI.Person_getMass(typeID);
  }

  public static TraCIColor getColor(String typeID) {
    return new TraCIColor(libsumoJNI.Person_getColor(typeID), true);
  }

  public static double getMinGapLat(String typeID) {
    return libsumoJNI.Person_getMinGapLat(typeID);
  }

  public static double getMaxSpeedLat(String typeID) {
    return libsumoJNI.Person_getMaxSpeedLat(typeID);
  }

  public static String getLateralAlignment(String typeID) {
    return libsumoJNI.Person_getLateralAlignment(typeID);
  }

  public static int getPersonCapacity(String typeID) {
    return libsumoJNI.Person_getPersonCapacity(typeID);
  }

  public static double getActionStepLength(String typeID) {
    return libsumoJNI.Person_getActionStepLength(typeID);
  }

  public static double getSpeedDeviation(String typeID) {
    return libsumoJNI.Person_getSpeedDeviation(typeID);
  }

  public static double getBoardingDuration(String typeID) {
    return libsumoJNI.Person_getBoardingDuration(typeID);
  }

  public static double getImpatience(String typeID) {
    return libsumoJNI.Person_getImpatience(typeID);
  }

  public static void add(String personID, String edgeID, double pos, double depart, String typeID) {
    libsumoJNI.Person_add__SWIG_0(personID, edgeID, pos, depart, typeID);
  }

  public static void add(String personID, String edgeID, double pos, double depart) {
    libsumoJNI.Person_add__SWIG_1(personID, edgeID, pos, depart);
  }

  public static void add(String personID, String edgeID, double pos) {
    libsumoJNI.Person_add__SWIG_2(personID, edgeID, pos);
  }

  public static void appendStage(String personID, TraCIStage stage) {
    libsumoJNI.Person_appendStage(personID, TraCIStage.getCPtr(stage), stage);
  }

  public static void replaceStage(String personID, int stageIndex, TraCIStage stage) {
    libsumoJNI.Person_replaceStage(personID, stageIndex, TraCIStage.getCPtr(stage), stage);
  }

  public static void appendWaitingStage(String personID, double duration, String description, String stopID) {
    libsumoJNI.Person_appendWaitingStage__SWIG_0(personID, duration, description, stopID);
  }

  public static void appendWaitingStage(String personID, double duration, String description) {
    libsumoJNI.Person_appendWaitingStage__SWIG_1(personID, duration, description);
  }

  public static void appendWaitingStage(String personID, double duration) {
    libsumoJNI.Person_appendWaitingStage__SWIG_2(personID, duration);
  }

  public static void appendWalkingStage(String personID, StringVector edges, double arrivalPos, double duration, double speed, String stopID) {
    libsumoJNI.Person_appendWalkingStage__SWIG_0(personID, StringVector.getCPtr(edges), edges, arrivalPos, duration, speed, stopID);
  }

  public static void appendWalkingStage(String personID, StringVector edges, double arrivalPos, double duration, double speed) {
    libsumoJNI.Person_appendWalkingStage__SWIG_1(personID, StringVector.getCPtr(edges), edges, arrivalPos, duration, speed);
  }

  public static void appendWalkingStage(String personID, StringVector edges, double arrivalPos, double duration) {
    libsumoJNI.Person_appendWalkingStage__SWIG_2(personID, StringVector.getCPtr(edges), edges, arrivalPos, duration);
  }

  public static void appendWalkingStage(String personID, StringVector edges, double arrivalPos) {
    libsumoJNI.Person_appendWalkingStage__SWIG_3(personID, StringVector.getCPtr(edges), edges, arrivalPos);
  }

  public static void appendDrivingStage(String personID, String toEdge, String lines, String stopID) {
    libsumoJNI.Person_appendDrivingStage__SWIG_0(personID, toEdge, lines, stopID);
  }

  public static void appendDrivingStage(String personID, String toEdge, String lines) {
    libsumoJNI.Person_appendDrivingStage__SWIG_1(personID, toEdge, lines);
  }

  public static void removeStage(String personID, int nextStageIndex) {
    libsumoJNI.Person_removeStage(personID, nextStageIndex);
  }

  public static void rerouteTraveltime(String personID) {
    libsumoJNI.Person_rerouteTraveltime(personID);
  }

  public static void moveTo(String personID, String laneID, double pos, double posLat) {
    libsumoJNI.Person_moveTo__SWIG_0(personID, laneID, pos, posLat);
  }

  public static void moveTo(String personID, String laneID, double pos) {
    libsumoJNI.Person_moveTo__SWIG_1(personID, laneID, pos);
  }

  public static void moveToXY(String personID, String edgeID, double x, double y, double angle, int keepRoute, double matchThreshold) {
    libsumoJNI.Person_moveToXY__SWIG_0(personID, edgeID, x, y, angle, keepRoute, matchThreshold);
  }

  public static void moveToXY(String personID, String edgeID, double x, double y, double angle, int keepRoute) {
    libsumoJNI.Person_moveToXY__SWIG_1(personID, edgeID, x, y, angle, keepRoute);
  }

  public static void moveToXY(String personID, String edgeID, double x, double y, double angle) {
    libsumoJNI.Person_moveToXY__SWIG_2(personID, edgeID, x, y, angle);
  }

  public static void moveToXY(String personID, String edgeID, double x, double y) {
    libsumoJNI.Person_moveToXY__SWIG_3(personID, edgeID, x, y);
  }

  public static void remove(String personID, char reason) {
    libsumoJNI.Person_remove__SWIG_0(personID, reason);
  }

  public static void remove(String personID) {
    libsumoJNI.Person_remove__SWIG_1(personID);
  }

  public static void setSpeed(String personID, double speed) {
    libsumoJNI.Person_setSpeed(personID, speed);
  }

  public static void setType(String personID, String typeID) {
    libsumoJNI.Person_setType(personID, typeID);
  }

  public static void setLength(String typeID, double length) {
    libsumoJNI.Person_setLength(typeID, length);
  }

  public static void setMaxSpeed(String typeID, double speed) {
    libsumoJNI.Person_setMaxSpeed(typeID, speed);
  }

  public static void setVehicleClass(String typeID, String clazz) {
    libsumoJNI.Person_setVehicleClass(typeID, clazz);
  }

  public static void setSpeedFactor(String typeID, double factor) {
    libsumoJNI.Person_setSpeedFactor(typeID, factor);
  }

  public static void setAccel(String typeID, double accel) {
    libsumoJNI.Person_setAccel(typeID, accel);
  }

  public static void setDecel(String typeID, double decel) {
    libsumoJNI.Person_setDecel(typeID, decel);
  }

  public static void setEmergencyDecel(String typeID, double decel) {
    libsumoJNI.Person_setEmergencyDecel(typeID, decel);
  }

  public static void setApparentDecel(String typeID, double decel) {
    libsumoJNI.Person_setApparentDecel(typeID, decel);
  }

  public static void setImperfection(String typeID, double imperfection) {
    libsumoJNI.Person_setImperfection(typeID, imperfection);
  }

  public static void setTau(String typeID, double tau) {
    libsumoJNI.Person_setTau(typeID, tau);
  }

  public static void setEmissionClass(String typeID, String clazz) {
    libsumoJNI.Person_setEmissionClass(typeID, clazz);
  }

  public static void setShapeClass(String typeID, String shapeClass) {
    libsumoJNI.Person_setShapeClass(typeID, shapeClass);
  }

  public static void setWidth(String typeID, double width) {
    libsumoJNI.Person_setWidth(typeID, width);
  }

  public static void setHeight(String typeID, double height) {
    libsumoJNI.Person_setHeight(typeID, height);
  }

  public static void setMass(String typeID, double mass) {
    libsumoJNI.Person_setMass(typeID, mass);
  }

  public static void setColor(String typeID, TraCIColor color) {
    libsumoJNI.Person_setColor(typeID, TraCIColor.getCPtr(color), color);
  }

  public static void setMinGap(String typeID, double minGap) {
    libsumoJNI.Person_setMinGap(typeID, minGap);
  }

  public static void setMinGapLat(String typeID, double minGapLat) {
    libsumoJNI.Person_setMinGapLat(typeID, minGapLat);
  }

  public static void setMaxSpeedLat(String typeID, double speed) {
    libsumoJNI.Person_setMaxSpeedLat(typeID, speed);
  }

  public static void setLateralAlignment(String typeID, String latAlignment) {
    libsumoJNI.Person_setLateralAlignment(typeID, latAlignment);
  }

  public static void setActionStepLength(String typeID, double actionStepLength, boolean resetActionOffset) {
    libsumoJNI.Person_setActionStepLength__SWIG_0(typeID, actionStepLength, resetActionOffset);
  }

  public static void setActionStepLength(String typeID, double actionStepLength) {
    libsumoJNI.Person_setActionStepLength__SWIG_1(typeID, actionStepLength);
  }

  public static void setBoardingDuration(String typeID, double boardingDuration) {
    libsumoJNI.Person_setBoardingDuration(typeID, boardingDuration);
  }

  public static void setImpatience(String typeID, double impatience) {
    libsumoJNI.Person_setImpatience(typeID, impatience);
  }

  public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
    libsumoJNI.Person_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
  }

  public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
    libsumoJNI.Person_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
  }

  public static void subscribe(String objectID, IntVector varIDs, double begin) {
    libsumoJNI.Person_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
  }

  public static void subscribe(String objectID, IntVector varIDs) {
    libsumoJNI.Person_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
  }

  public static void subscribe(String objectID) {
    libsumoJNI.Person_subscribe__SWIG_4(objectID);
  }

  public static void unsubscribe(String objectID) {
    libsumoJNI.Person_unsubscribe(objectID);
  }

  public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
    libsumoJNI.Person_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
  }

  public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
    libsumoJNI.Person_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
  }

  public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
    libsumoJNI.Person_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
  }

  public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
    libsumoJNI.Person_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
  }

  public static void subscribeContext(String objectID, int domain, double dist) {
    libsumoJNI.Person_subscribeContext__SWIG_4(objectID, domain, dist);
  }

  public static void unsubscribeContext(String objectID, int domain, double dist) {
    libsumoJNI.Person_unsubscribeContext(objectID, domain, dist);
  }

  public static SubscriptionResults getAllSubscriptionResults() {
    return new SubscriptionResults(libsumoJNI.Person_getAllSubscriptionResults(), true);
  }

  public static TraCIResults getSubscriptionResults(String objectID) {
    return new TraCIResults(libsumoJNI.Person_getSubscriptionResults(objectID), true);
  }

  public static ContextSubscriptionResults getAllContextSubscriptionResults() {
    return new ContextSubscriptionResults(libsumoJNI.Person_getAllContextSubscriptionResults(), true);
  }

  public static SubscriptionResults getContextSubscriptionResults(String objectID) {
    return new SubscriptionResults(libsumoJNI.Person_getContextSubscriptionResults(objectID), true);
  }

  public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
    libsumoJNI.Person_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
  }

  public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
    libsumoJNI.Person_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
  }

  public static void subscribeParameterWithKey(String objectID, String key) {
    libsumoJNI.Person_subscribeParameterWithKey__SWIG_2(objectID, key);
  }

  public static int getDOMAIN_ID() {
    return libsumoJNI.Person_DOMAIN_ID_get();
  }

  public static int domainID() {
    return libsumoJNI.Person_domainID();
  }

}
